#include "util.h"

extern char outputVector[100];

/************************************************************************/
/* Name: drawVector
/* Function: draw one Vector Image.
/* Input: vet: a pointer to this char.
		  id: the order of this char.
/* Output: 
/* Return:
/* Explain:
/* Amendant record			
/* Date          Edition       Modifier      Summary
/* 10/12/2009    V1.0          Suqin Ao      Establish 
/************************************************************************/
void drawVector(PointA *vet, int id)
{
	int iNum = vet->num;
	int iHeight =128;
	FILE *fVector;
	//char temp[100];
	char fName[100];

	memset(fName, 0, 100);
	strcpy(fName, OUTPUT_VECTOR_PATH);
	strcat(fName, OUTPUT_VECTOR_NAME);
	sprintf(outputVector, fName, id);

	if(!(fVector = fopen(outputVector, "wb")))
	{
		printf("Cannot open this file!");
		return;
	}
	
	/********write "BM"***********/
	char str[1000];
	strcpy(str, "BM");
	fwrite(str, sizeof(BYTE), 2, fVector);
	
	/********write the size of the file********/
	BYTE size[4];
	BYTE oneAll = 255;
	size[0] = 3 * 16 + 14;
	size[1] = 8;
	size[2] = 0;
	size[3] = 0;
	fwrite(size, sizeof(BYTE), 4, fVector);

	/********ignore the reserved********/
	size[0] = 0;
	size[1] = 0;
	size[2] = 0;
	size[3] = 0;
	fwrite(size, sizeof(BYTE), 4, fVector);

	/********write the start position of the image data********/
	size[0] = 62;//3EH
	fwrite(size, sizeof(BYTE), 4, fVector);
	
	/********write the size of info header, the default is 28H********/
	size[0] = 40;//28H
	fwrite(size, sizeof(BYTE), 4, fVector);

	/********write the width, height of image, the default is 128********/
	size[0] = 128;
	fwrite(size, sizeof(BYTE), 4, fVector);
	fwrite(size, sizeof(BYTE), 4, fVector);

	/********write number of planes, the default is 1********/
	size[0] = 1;
	fwrite(size, sizeof(BYTE), 1, fVector);
	fwrite(size, sizeof(BYTE), 1, fVector);

	/********write number of bits to denote a pixel, the default is 1********/
	fwrite(size, sizeof(BYTE), 2, fVector);


	/********write the way of compressed, the default is 0********/
	size[0] = 0;
	fwrite(size, sizeof(BYTE), 4, fVector);

	/********write size of image data********/
	size[1] = 8;//2048
	fwrite(size, sizeof(BYTE), 4, fVector);

	size[1] = 0;

	int i, j, pos, mov;
	for(i = 0; i < 5; i ++)
		fwrite(size, sizeof(BYTE), 4, fVector);

	size[0] = 255;
	size[1] = 255;
	size[2] = 255;
	fwrite(size, sizeof(BYTE), 4, fVector);

	BYTE image[2048];
	memset(image, 255, 2048);

	BYTE x, y, x1, y1;
	BYTE gray = 128;

	/********write image data********/
	for(i = 0; i < vet->num; i ++)//strok
	{
		for(j = 0; j < vet->stroke[i]->num; j ++)//point(x, y)
		{
			x1 = vet->stroke[i]->X[j];
			y1 = vet->stroke[i]->Y[j];

			x = 127 -y1;
			y = x1;
			pos = (int)(x * 128 + y) / 8;
			mov = (int)(x * 128 + y) % 8;
			image[pos] = (gray >> mov) ^ image[pos];

		}
	}
	fwrite(image, sizeof(BYTE), 2048, fVector);

	fclose(fVector);
}